--[[
    ╔══════════════════════════════════════════════════╗
    ║        CFX-NOTIFICAÇÕES - Configuração           ║
    ║        Sistema de Notificações para FiveM        ║
    ║                  by CfxAI                        ║
    ╚══════════════════════════════════════════════════╝
]]

Config = {}

-- Duração padrão das notificações em milissegundos
Config.DefaultDuration = 5000

-- Posição das notificações na tela
-- Opções: 'top-right', 'top-left', 'bottom-right', 'bottom-left', 'top-center', 'bottom-center'
Config.Position = 'top-right'

-- Número máximo de notificações visíveis ao mesmo tempo
Config.MaxNotifications = 5

-- Tocar som ao receber notificação
Config.PlaySound = true

-- Tipos de notificação disponíveis
-- Cada tipo possui um ícone e cor associados (definidos no CSS)
Config.Types = {
    ['success'] = {
        label = 'Sucesso',          -- Rótulo exibido no título padrão
        icon = 'fa-check-circle',   -- Ícone do Font Awesome
        color = '#22c55e',          -- Cor verde para sucesso
    },
    ['error'] = {
        label = 'Erro',             -- Rótulo exibido no título padrão
        icon = 'fa-times-circle',   -- Ícone do Font Awesome
        color = '#ef4444',          -- Cor vermelha para erro
    },
    ['info'] = {
        label = 'Informação',       -- Rótulo exibido no título padrão
        icon = 'fa-info-circle',    -- Ícone do Font Awesome
        color = '#3b82f6',          -- Cor azul para informação
    },
    ['warning'] = {
        label = 'Aviso',            -- Rótulo exibido no título padrão
        icon = 'fa-exclamation-triangle', -- Ícone do Font Awesome
        color = '#f59e0b',          -- Cor amarela para aviso
    },
}

-- Comando de teste (definir como false para desativar)
Config.TestCommand = 'notificar'

-- Comando de anúncio para administradores
Config.AnnounceCommand = 'anuncio'

-- Grupo de permissão necessário para usar o comando de anúncio
-- Utiliza o sistema de permissões do QBCore
Config.AdminGroup = 'admin'
