--[[
    cfx-npc-shop | Configuracao Geral
    Sistema de Loja com NPC para FiveM (ESX Legacy)
    Desenvolvido por CfxAI
]]

Config = {}

-- Se true, usa ox_target para interacao. Se false, usa tecla de interacao (padrao: E)
Config.UseTarget = false

-- Distancia maxima para interagir com o NPC (quando Config.UseTarget = false)
Config.InteractionDistance = 2.0

-- Tecla de interacao (38 = E) - usado apenas quando Config.UseTarget = false
Config.InteractionKey = 38

-- Moeda exibida nos precos
Config.CurrencySymbol = 'R$'

-- Metodo de pagamento padrao: 'cash' ou 'bank'
-- O jogador pode escolher no menu, mas este e o padrao
Config.DefaultPayment = 'cash'

-------------------------------------------------------------------------------
-- LOJAS
-- Cada loja possui:
--   name     = Nome exibido no menu
--   blip     = Configuracoes do blip no mapa {sprite, color, scale, label}
--   ped      = Configuracoes do NPC {model, coords (vector4 com heading), scenario}
--   items    = Lista de itens disponiveis {name, label, price}
--
-- Observacao: os nomes dos itens (name) devem corresponder aos itens
-- cadastrados no seu banco de dados / items do ESX.
-------------------------------------------------------------------------------

Config.Shops = {
    -- =========================================================================
    -- LOJA 1: 24/7 Conveniencia
    -- =========================================================================
    {
        name = '24/7 Conveniencia',

        blip = {
            sprite = 59,        -- Icone de carrinho de compras
            color  = 2,         -- Verde
            scale  = 0.8,
            label  = '24/7 Conveniencia'
        },

        ped = {
            model    = 'mp_m_shopkeep_01',                        -- Modelo do lojista
            coords   = vector4(25.7, -1347.3, 29.5, 271.0),      -- Posicao e direcao do NPC
            scenario = 'WORLD_HUMAN_STAND_MOBILE'                 -- Animacao idle do NPC
        },

        items = {
            { name = 'water',    label = 'Agua',          price = 10 },
            { name = 'bread',    label = 'Pao',           price = 15 },
            { name = 'donut',    label = 'Rosquinha',     price = 12 },
        }
    },

    -- =========================================================================
    -- LOJA 2: Ferramentas
    -- =========================================================================
    {
        name = 'Ferramentas',

        blip = {
            sprite = 402,       -- Icone de ferramenta
            color  = 5,         -- Amarelo
            scale  = 0.8,
            label  = 'Loja de Ferramentas'
        },

        ped = {
            model    = 's_m_y_construct_02',                      -- Modelo de operario
            coords   = vector4(45.6, -1749.0, 29.6, 50.0),       -- Posicao e direcao do NPC
            scenario = 'WORLD_HUMAN_CLIPBOARD'                    -- Animacao com prancheta
        },

        items = {
            { name = 'lockpick',    label = 'Kit de Lockpick',    price = 150 },
            { name = 'repairkit',   label = 'Kit de Reparo',      price = 300 },
            { name = 'flashlight',  label = 'Lanterna',           price = 80  },
        }
    },

    -- =========================================================================
    -- LOJA 3: Farmacia
    -- =========================================================================
    {
        name = 'Farmacia',

        blip = {
            sprite = 403,       -- Icone de cruz/saude
            color  = 1,         -- Vermelho
            scale  = 0.8,
            label  = 'Farmacia'
        },

        ped = {
            model    = 's_f_y_scrubs_01',                         -- Modelo de enfermeira
            coords   = vector4(-253.5, 6336.5, 32.4, 310.0),     -- Posicao e direcao do NPC
            scenario = 'WORLD_HUMAN_STAND_MOBILE'                 -- Animacao idle
        },

        items = {
            { name = 'bandage',      label = 'Bandagem',          price = 50  },
            { name = 'medikit',      label = 'Kit Medico',        price = 200 },
            { name = 'painkillers',  label = 'Analgesicos',       price = 75  },
        }
    },
}
