-- ============================================================
-- cfx-velocimetro | Client Script
-- Velocimetro HUD moderno para FiveM
-- Standalone - Funciona com qualquer framework
-- by CfxAI
-- ============================================================

-- Variavel para controlar se o velocimetro esta ativo
local velocimetroAtivo = true

-- Variavel para saber se o jogador esta em um veiculo
local dentroDoVeiculo = false

-- ============================================================
-- Comando para ativar/desativar o velocimetro
-- ============================================================
RegisterCommand('velocimetro', function()
    velocimetroAtivo = not velocimetroAtivo

    if velocimetroAtivo then
        TriggerEvent('chat:addMessage', {
            color = {249, 115, 22},
            args = {'Velocimetro', 'Ativado'}
        })
    else
        -- Se desativou, esconde o HUD imediatamente
        SendNUIMessage({
            action = 'esconder'
        })
        TriggerEvent('chat:addMessage', {
            color = {249, 115, 22},
            args = {'Velocimetro', 'Desativado'}
        })
    end
end, false)

-- ============================================================
-- Thread principal - Detecta entrada/saida do veiculo
-- e envia dados para o NUI
-- ============================================================
Citizen.CreateThread(function()
    while true do
        -- Reduz o uso da CPU quando nao esta em veiculo
        local tempoEspera = 500

        local jogador = PlayerPedId()
        local estaEmVeiculo = IsPedInAnyVehicle(jogador, false)

        -- Jogador acabou de entrar em um veiculo
        if estaEmVeiculo and not dentroDoVeiculo then
            dentroDoVeiculo = true
            if velocimetroAtivo then
                SendNUIMessage({
                    action = 'mostrar'
                })
            end
        end

        -- Jogador acabou de sair do veiculo
        if not estaEmVeiculo and dentroDoVeiculo then
            dentroDoVeiculo = false
            SendNUIMessage({
                action = 'esconder'
            })
        end

        -- Se esta dentro do veiculo e o velocimetro esta ativo, envia os dados
        if estaEmVeiculo and velocimetroAtivo then
            tempoEspera = 100 -- Atualiza a cada 100ms quando em veiculo

            local veiculo = GetVehiclePedIsIn(jogador, false)

            -- Calcula a velocidade em km/h
            -- GetEntitySpeed retorna em m/s, multiplicamos por 3.6 para km/h
            local velocidadeMs = GetEntitySpeed(veiculo)
            local velocidadeKmh = math.floor(velocidadeMs * 3.6)

            -- Obtem o RPM do veiculo (valor entre 0.0 e 1.0)
            local rpm = GetVehicleCurrentRpm(veiculo)

            -- Obtem a marcha atual do veiculo
            local marcha = GetVehicleCurrentGear(veiculo)

            -- Obtem o nivel de combustivel (valor entre 0.0 e 100.0)
            local combustivel = GetVehicleFuelLevel(veiculo)

            -- Garante que o combustivel nao passe de 100
            if combustivel > 100.0 then
                combustivel = 100.0
            end

            -- Obtem a velocidade maxima do veiculo para referencia
            -- Classe do veiculo para exibir icone adequado
            local classeVeiculo = GetVehicleClass(veiculo)

            -- Verifica se as luzes estao acesas
            local _, luzesFrente, luzesAltas = GetVehicleLightsState(veiculo)

            -- Verifica se o motor esta ligado
            local motorLigado = GetIsVehicleEngineRunning(veiculo)

            -- Envia todos os dados para a interface NUI
            SendNUIMessage({
                action = 'atualizar',
                velocidade = velocidadeKmh,
                rpm = rpm,
                marcha = marcha,
                combustivel = math.floor(combustivel),
                classeVeiculo = classeVeiculo,
                luzes = luzesFrente == 1 or luzesAltas == 1,
                motor = motorLigado
            })
        end

        Citizen.Wait(tempoEspera)
    end
end)
